/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.network.config.DHCPServerRangeConfig;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class NetworkInterfaceInformation
implements Serializable,
Cloneable {
    static final long serialVersionUID = -789804501852922893L;
    private static final String TRACE_MASKT = "XSETNIIT";
    private static final String TRACE_MASKF = "XSETNIIF";
    private static final String TRACE_MASKD = "XSETNIID";
    public static final int TYPE_UNKNOWN = 1;
    public static final int TYPE_TOKENRING = 1;
    public static final int TYPE_ETHERNET = 2;
    private InetAddress address;
    private InetAddress netmask;
    private int type;
    private String ifname;
    private String mac;
    private boolean dhcpClient;
    private boolean privateIf;
    private boolean dhcpServer;
    private DHCPServerRangeConfig dhcpServerConfig;
    private List firewallRules;
    private boolean configured;
    private boolean partitionCommunication;
    private String driver;
    private String mediaSpeed;

    public NetworkInterfaceInformation() {
        Trace.trace(TRACE_MASKT, "NetworkInterfaceInformation default ctor->");
        this.type = 1;
        this.mac = "";
        this.dhcpClient = false;
        this.privateIf = true;
        Trace.trace(TRACE_MASKT, "privateIf set true (PHMC default)");
        this.driver = "";
        this.mediaSpeed = "";
        this.dhcpServer = false;
        this.dhcpServerConfig = new DHCPServerRangeConfig();
        this.configured = false;
        this.partitionCommunication = false;
        Trace.trace(TRACE_MASKT, "<- NetworkInterfaceInformation default ctor");
    }

    public NetworkInterfaceInformation(InetAddress address, InetAddress netmask, int type, String mac, boolean dhcpClient, boolean privateIf, String driver, String mediaSpeed, boolean dhcpServer, DHCPServerRangeConfig dhcpServerConfig, boolean configured, boolean partitionCommunication) {
        Trace.trace(TRACE_MASKT, "NetworkInterfaceInformation full ctor<>");
        this.type = type;
        this.mac = mac;
        this.address = address;
        this.netmask = netmask;
        this.dhcpClient = dhcpClient;
        this.privateIf = privateIf;
        this.driver = driver;
        this.mediaSpeed = mediaSpeed;
        this.dhcpServer = dhcpServer;
        this.dhcpServerConfig = dhcpServerConfig;
        this.configured = configured;
        this.partitionCommunication = partitionCommunication;
    }

    public NetworkInterfaceInformation(String address, String netmask, String ifname, String mac, boolean dhcpClient, boolean privateIf, String driver, String mediaSpeed, boolean dhcpServer, DHCPServerRangeConfig dhcpServerConfig, boolean configured, boolean partitionCommunication) {
        this(null, null, 1, mac, dhcpClient, privateIf, driver, mediaSpeed, dhcpServer, dhcpServerConfig, configured, partitionCommunication);
        Trace.trace(TRACE_MASKT, "NetworkInterfaceInformation full string ctor<>");
        if (address.length() == 0) {
            Trace.trace(TRACE_MASKT, "Null IPAddress - set it to 0.0.0.0");
            address = "0.0.0.0";
        }
        try {
            this.address = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            Trace.trace(TRACE_MASKT, "Just eat this exception and leave the address as null");
        }
        if (netmask.length() == 0) {
            Trace.trace(TRACE_MASKT, "Null NetMask Address - set it to 255.255.255.0");
            netmask = "255.255.255.0";
        }
        try {
            this.netmask = InetAddress.getByName(netmask);
        }
        catch (UnknownHostException e) {
            Trace.trace(TRACE_MASKT, "Just eat this exception and leave the address as null");
        }
        this.ifname = ifname;
        if (ifname.startsWith("tr")) {
            this.type = 1;
        } else if (ifname.startsWith("eth")) {
            this.type = 2;
        }
    }

    public String getIpAddr() {
        String ipaddr = "";
        try {
            ipaddr = this.address.getHostAddress();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return ipaddr;
    }

    public String getNetMask() {
        String nmask = "";
        try {
            nmask = this.netmask.getHostAddress();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return nmask;
    }

    public InetAddress getIpAddress() {
        return this.address;
    }

    public void setIpAddress(InetAddress address) {
        this.address = address;
    }

    public InetAddress getNetworkMask() {
        return this.netmask;
    }

    public void setNetworkMask(InetAddress netmask) {
        this.netmask = netmask;
    }

    public String getIfname() {
        return this.ifname;
    }

    public void setIfname(String ifname) {
        this.ifname = ifname;
    }

    public int getAdapterType() {
        return this.type;
    }

    public void setAdapterType(int type) {
        this.type = type;
    }

    public String getMacAddress() {
        return this.mac;
    }

    public void setMacAddress(String mac) {
        this.mac = mac;
    }

    public boolean isDhcpClient() {
        return this.dhcpClient;
    }

    public void setDhcpClient(boolean dhcpClient) {
        this.dhcpClient = dhcpClient;
    }

    public boolean isPrivateIf() {
        return this.privateIf;
    }

    public void setPrivateIf(boolean privateIf) {
        this.privateIf = privateIf;
    }

    public boolean isPartitionCommunication() {
        return this.partitionCommunication;
    }

    public void setPartitionCommunication(boolean partitionCommunication) {
        this.partitionCommunication = partitionCommunication;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getMediaSpeed() {
        return this.mediaSpeed;
    }

    public void setMediaSpeed(String mediaSpeed) {
        this.mediaSpeed = mediaSpeed;
    }

    public boolean isDhcpServer() {
        return this.dhcpServer;
    }

    public void setDhcpServer(boolean dhcpServer) {
        this.dhcpServer = dhcpServer;
    }

    public DHCPServerRangeConfig getDhcpServerRangeConfig() {
        return this.dhcpServerConfig;
    }

    public void setDhcpServerRangeConfig(DHCPServerRangeConfig dhcpServerConfig) {
        this.dhcpServerConfig = dhcpServerConfig;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public void setFirewallRules(List firewallRules) {
        this.firewallRules = firewallRules;
    }

    public List getFirewallRules() {
        return this.firewallRules;
    }

    public String toString() {
        String s = this.getClass().getName() + ": address=[";
        s = this.address != null ? s + this.address : s + "null";
        s = s + "]; netmask=[";
        s = this.netmask != null ? s + this.netmask : s + "null";
        s = s + "]; type=[";
        switch (this.type) {
            case 1: {
                s = s + "token ring";
                break;
            }
            case 2: {
                s = s + "ethernet";
                break;
            }
            default: {
                s = s + "unknown";
            }
        }
        s = s + "]; mac address=[" + this.mac + "]; dhcpClient=[";
        s = this.dhcpClient ? s + "true" : s + "false";
        s = s + "];";
        return s;
    }
}

